local ret = ... or {};

ret.RedirTable = {
	Up = "Up",
	Down = "Down",
	Left = "Left",
	Right = "Right",
	UpLeft = "UpLeft",
	UpRight = "UpRight",
}

local OldRedir = ret.Redir
ret.Redir = function(sButton, sElement)
	sButton, sElement = OldRedir(sButton, sElement)

	--we want to use custom hold/roll per direction, but
	--keep global hold/roll heads and explosions.	
	if not string.find(sElement, "Head") and
	not string.find(sElement, "Explosion") then
		if string.find(sElement, "Hold") or
		string.find(sElement, "Roll") then
			return sButton, sElement;
		end
	end

	sButton = ret.RedirTable[sButton]

	return sButton, sElement
end

local OldFunc = ret.Load
function ret.Load()
	local t = OldFunc()

	--Explosion should not be rotated; it calls other actors.
	if Var "Element" == "Explosion"	then
		t.BaseRotationZ = nil
	end
	return t
end

ret.PartsToRotate = {
	["Receptor"] = true,
	["Tap Explosion Bright"] = true,
	["Tap Explosion Dim"] = true,
	["Tap Note"] = true,
	["Tap Mine"] = false,
	["Tap Lift"] = true,
	["Tap Fake"] = true,
	["Tap Addition"] = true,
	["Hold Explosion"] = true,
	["Hold Head Active"] = true,
	["Hold Head Inactive"] = true,
	["Roll Explosion"] = true,
	["Roll Head Active"] = true,
	["Roll Head Inactive"] = true,
	["Hold LiftTail Active"] = true,
	["Hold LiftTail Inactive"] = true,
	["Roll LiftTail Active"] = true,
	["Roll LiftTail Inactive"] = true,
}

ret.Rotate = {
	Up = 180,
	Down = 0,
	Left = 90,
	Right = -90,
	UpLeft = 0,
	UpRight = 0,
}

ret.Blank = {
	--["Hold Topcap Active"] = true,
	--["Hold Topcap Inactive"] = true,
	--["Roll Topcap Active"] = true,
	--["Roll Topcap Inactive"] = true,
	["Hold Tail Active"] = true,
	["Hold Tail Inactive"] = true,
	["Roll Tail Active"] = true,
	["Roll Tail Inactive"] = true,
}

return ret
