local pn, name, mirrorX = ...

local t = Def.ActorFrame({
    LoadActor(NOTESKIN:GetPath('Graphics/'..name, 'Receptor'))..{
        BaseZoomX = mirrorX and -1 or 1,
        Name = 'Receptor',
        InitCommand = NOTESKIN:GetMetricA('ReceptorArrow', 'InitCommand'),
        NoneCommand = NOTESKIN:GetMetricA('ReceptorArrow', 'NoneCommand'),
    },
})

local steps = nil
local curSong = nil
local timing = nil
local startBeat = 9999

local function UpdateSong(song)
    curSong = song
    steps = GAMESTATE:GetCurrentSteps(pn)
    timing = steps:GetTimingData()
    startBeat = timing:GetBeatFromElapsedTime(song:GetFirstSecond()) - 8
end

local function UpdateReceptor(child, pn)
    local curSec = GAMESTATE:GetCurMusicSeconds()
    local curBeat = timing:GetBeatFromElapsedTime(curSec)
    local beat = steps and math.floor(curBeat*10)%10 or 0
    if curBeat >= startBeat then
        child:setstate((beat >= 1 and beat <= 8) and 1 or 0)
    end
end

local fps = 60
local wait = 1.0/fps
local last = 0
local function update(self, delta)
    last = last + delta
    if curSong ~= GAMESTATE:GetCurrentSong() then
        UpdateSong(GAMESTATE:GetCurrentSong())
        self:setstate(2)
    end
    if last > wait then
        last = 0
        UpdateReceptor(self:GetChild("Receptor"))
    end
end

t.InitCommand=cmd(SetUpdateFunction,update)
return t
